<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:utr="http://www.xbrl.org/2009/utr"
  xmlns="http://www.w3.org/1999/xhtml" 
  xmlns:MathML="http://www.w3.org/1998/Math/MathML">

  <xsl:output method="html" encoding="UTF-8" indent="no" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>Unit Type Registry</title>
        <meta http-equiv="content-type" content="application/xhtml+xml; charset=UTF-8" />
           
        <style type="text/css">
          body {
          font-family: Verdana, Helvetica, Geneva, Arial, SunSans-Regular, sans-serif;
          font-size: 11px;
          vertical-align: top;
          }
          
          table, td, th {
          font-size: 11px;
          border-width: 1px;
          border-spacing: 0px;
          border-style: solid;
          border-collapse: separate;
          vertical-align: top;
          border-color: #B0E0E6;
          empty-cells: show;
          }
          
          th {
          font-family: Verdana, Helvetica, Geneva, Arial, SunSans-Regular, sans-serif;
          font-weight: bold;
          color: #FFFFFF;
          background-color:  #006DB5;
          }
        </style>
      </head>
      <body>
        <table>
          <tr>
            <th>unitId</th>
            <th>unitName</th>
            <th>nsUnit</th>
            <th>status</th>
            <th>versionDate</th>   
            <th>itemType</th>
            <th>nsItemType</th>         
            <th>itemTypeDate</th>
            <th>symbol</th>
            <th>definition</th>
            <th>baseStandard</th>
            <th>conversionPresentation</th>
            <th>conversionContent</th>            
            <th>numeratorItemType</th>
            <th>nsNumeratorItemType</th>
            <th>denominatorItemType</th>
            <th>nsDenominatorItemType</th>
          </tr>
          <xsl:apply-templates/>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="utr:units|utr:utr">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="utr:unit">
    <tr xmlns="http://www.w3.org/1999/xhtml">
      <td><xsl:value-of select="utr:unitId/text()"/></td>
      <td><xsl:value-of select="utr:unitName/text()"/></td>
      <td nowrap="nowrap"><xsl:value-of select="utr:nsUnit/text()"/></td>
      <td><xsl:value-of select="utr:status/text()"/></td>
      <td nowrap="nowrap"><xsl:value-of select="utr:versionDate/text()"/></td>
      <td><xsl:value-of select="utr:itemType/text()"/></td>
      <td nowrap="nowrap"><xsl:value-of select="utr:nsItemType/text()"/></td>
      <td nowrap="nowrap"><xsl:value-of select="utr:itemTypeDate/text()"/></td>      
      <td align="center"><xsl:value-of select="utr:symbol/text()"/></td>
      <td><xsl:value-of select="utr:definition/text()"/></td>
      <td><xsl:value-of select="utr:baseStandard/text()"/></td>
      <td><xsl:apply-templates select="utr:conversionPresentation"/></td>
      <td><xsl:apply-templates select="utr:conversionContent"/></td>
      <td><xsl:value-of select="utr:numeratorItemType/text()"/></td>
      <td nowrap="nowrap"><xsl:value-of select="utr:nsNumeratorItemType/text()"/></td>
      <td><xsl:value-of select="utr:denominatorItemType/text()"/></td>
      <td nowrap="nowrap"><xsl:value-of select="utr:nsDenominatorItemType/text()"/></td>
    </tr>
</xsl:template>

  <xsl:template match="utr:conversionPresentation|utr:conversionContent" >
    <xsl:copy-of select="MathML:math"/>
  </xsl:template>

</xsl:stylesheet>